package music;

public class EmptyPlaylistException extends Exception {
	
	private int noOfSongs;

	public EmptyPlaylistException(int noOfSongs) {
		super();
		this.noOfSongs = noOfSongs;
	}

	public EmptyPlaylistException() {
		super();
	}
	
	@Override
	public String getMessage() {
		return "No. of songs: " + this.noOfSongs;
	}

	public int getNoOfSongs() {
		return noOfSongs;
	}

	public void setNoOfSongs(int noOfSongs) {
		this.noOfSongs = noOfSongs;
	}

}
